/** \file BoneCooker.cpp
 * \brief The implementation of the 'BoneCooker' class.
 */

#include "BoneCooker.h"
#include "Mesh.h"
#include "VertexBones.h"

namespace OSkA
{
	BoneCooker::BoneCooker()
	{
	}

	BoneCooker::~BoneCooker()
	{
		delete[] weightArray;
		delete[] influenceArray;
	}

	float* BoneCooker::getWeightArray()
	{
		return weightArray;
	}

	float* BoneCooker::getInfluenceArray()
	{
		return influenceArray;
	}

	void BoneCooker::consumeWeightArray(float* weightArray)
	{
		this->weightArray=weightArray;
	}

	void BoneCooker::consumeInfluenceArray(float* influenceArray)
	{
		this->influenceArray=influenceArray;
	}

	void BoneCooker::cook(Mesh* mesh)
	{
		float* baWeightArray=new float[4*mesh->getVerticesCount()];
		float* baInfluenceArray=new float[4*mesh->getVerticesCount()];

		for(int v=0; v<mesh->getVerticesCount(); v++)
		{
			float* w=mesh->getVertexBones(v)->getMaxWeightsIndices();
			memcpy(&baInfluenceArray[4*v], w, 4*sizeof(float));
		}

		for(int v=0; v<mesh->getVerticesCount(); v++)
		{
			float* w=mesh->getVertexBones(v)->getMaxWeights();
			memcpy(&baWeightArray[4*v], w, 4*sizeof(float));
		}

		consumeInfluenceArray(baInfluenceArray);
		consumeWeightArray(baWeightArray);
	}
}