/** \file Animation.cpp
 * \brief The implementation of the 'Animation' class.
 */

#include "Animation.h"

namespace OSkA
{
	Animation::Animation()
	{
		consumeName("");
		setLength(0);
		tracks.resize(0);
	}

	Animation::~Animation()
	{
		for(int i=0; i<tracks.size(); i++)
			delete tracks[i];
		tracks.clear();
	}

	Animation::Animation(char* name, float length)
	{
		consumeName(name);
		setLength(length);
		tracks.resize(0);
	}

	void Animation::consumeName(char* name)
	{
		this->name=name;
	}

	void Animation::setLength(float length)
	{
		this->length=length;
	}

	char* Animation::getName()
	{
		return name;
	}

	float Animation::getLength()
	{
		return length;
	}

	void Animation::addTrack(int boneIndex)
	{
		if(boneIndex >=getTracksCount())
			tracks.resize(boneIndex+1);
		for(int i=0; i<getTracksCount(); i++)
			if(!tracks[i])
				tracks[i]=new Track();
	}

	Track* Animation::getTrack(int boneIndex)
	{
		if(boneIndex >=getTracksCount())
			return new Track();
		return tracks[boneIndex];
	}

	int Animation::getTracksCount()
	{
		return tracks.size();
	}
}