#ifndef _TAKE_VBODATA_H_
#define _TAKE_VBODATA_H_

#include <GL/glew.h>
#ifdef WIN32
#include <GL/wglew.h>
#endif

#ifdef __APPLE__
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif

#include <ErrorManager/ErrorManager.h>
#include <GLSLProgram/GLSLProgram.h>

#include <iostream>
#include <string>
#include <vector>



/*		VertexBuffferObject class		*/
class CVBOData
{
public:
	enum MAP {
		NONE       = 0,
		READ       = GL_READ_ONLY_ARB,
		WRITE      = GL_WRITE_ONLY_ARB,
		READ_WRITE = GL_READ_WRITE_ARB
	};

protected:
	GLuint program;
	GLenum target;
	GLuint id;
	GLsizei size;

	unsigned int GLSLCount;
	std::vector<std::string> GLSLName;
	std::vector<GLint> GLSLLocation;

public:
	virtual void     DrawBuffer() const;
	virtual int      GetPrimitiveCount(void) const;
	virtual GLfloat* StartBufferOperation(MAP type);
	virtual void     StopBufferOperation();
	        void     Bind() const;
	        void     Unbind() const;

	CVBOData(GLuint pProgram);
	~CVBOData();
};

class CFeedbackBuffer : public CVBOData {
private:
	void CheckWriteStatus(void);
protected:
	GLenum usage;
	const GLvoid* data;
	GLenum bufferMode;
	GLuint primitiveQuery;
	GLenum writePrimitive;
	GLenum feedbackInterleavedFormat;
	MAP locked;
	const float * memoryPointerRead;
	float * memoryPointer;
public:
	CFeedbackBuffer(GLuint pProgram, GLsizei sz, GLenum wPrimitive);
	~CFeedbackBuffer();

	void AddGLSLVarying(std::string name);
	void Install();
	int GetPrimitiveCount(void) const;

	int GetVertexCount(void) const;
	unsigned int GetElement(int n) const;
	const float *GetVertex(int n);
	void AddColor(int n, float r, float g, float b);
	void SetColor(int n, float r, float g, float b);

	GLfloat * StartBufferOperation(MAP type);
	void StopBufferOperation();
	void BeginTransformFeedback();
	void EndTransformFeedback();
	void DrawArray(GLenum drawPrimitive) const;
	bool Draw(void);
};


#endif // _TAKE_VBODATA_H_
