/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


    Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_WALD_TRIANGLE_H
#define RT_WALD_TRIANGLE_H

namespace rt {
    // Wald's
    struct wald_tri_t {
        uint32_t k;
        float32_t    n_u;
        float32_t    n_v;
        float32_t    n_d;

        float32_t    vert_ku;    // don't need the full vert,
        float32_t    vert_kv;    // but only 2 components
        float32_t    b_nu;
        float32_t    b_nv;

        float32_t    c_nu;
        float32_t    c_nv;
        uint32_t id, matid;
    };
}

#endif
