/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_SAH_H
#define RT_SAH_H

namespace SAH {
	struct heuristic_t {
		double
			cost_traversal,			// cost for a node traversal
			cost_intersection,		// cost for a primitive intersection
			microscopic_cell_ratio;	// ratio for cell area to be considered as too small vs parent.
									//kdlib: gonna reuse it for the space cut minimal volume ratio

		uint_t
			depth_max,			// maximum depth
			leaf_count_max,		// min/max triangles per leaf
			leaf_count_min;
			//trigger_count;		// debug
		


		union {
			// they'll default to 0/false, word them accordingly.
			struct {
				uint_t	no_surrounding_splits : 1;
				uint_t	no_clipping : 1;
				uint_t	compress_ids : 1;
				uint_t	no_microscopic_cells : 1;
				uint_t	dont_clipall : 1;
			};
			uint_t bits;
		} tweaks;

		struct {
				uint_t	use_old : 1;
				uint_t	use_kdlib : 1;
		} version;

		// SAH tweaks
		uint_t	complex_heuristic_threshold;
	};
}

#endif
