/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_FRAMEBUFFER_H
#define RT_FRAMEBUFFER_H

#include "specifics.h"

namespace rt {
	struct pixel_t { 
		union {
			struct { float r,g,b, d; };
			__m128 ps;
		};
		explicit pixel_t(const float x, const float y, const float z, const float w) : r(x), g(y), b(z), d(w) {}
		explicit pixel_t(const __m128 v) : ps(v) {}
	};

	class framebuffer_t {
		pixel_t * __restrict fb;
		point_t resolution;
		bool_t owned;

	public:
		bool_t open(const point_t &res);
		void close();

		const point_t &get_resolution() const { return resolution; }

		void clear();

		// let's lie a bit
		void plot(const int x, const int y, const pixel_t &p) const { fb[y*resolution.x +x] = p; }
		void plot(const int idx, const pixel_t &p) const { fb[idx] = p; }
		// beware, aligned
		void plot(const int idx, const __m128 v) const { fb[idx].ps = v; }

		pixel_t *get() const { return fb; }

		// ugly addendum, but now the framebuffer might be in fact directly mapped to a gpu texture
		void allocate();
		void set(void *p);
	};
}

#endif
