/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_CAMERA_H
#define RT_CAMERA_H

#include "specifics.h"
#include "math_vec.h"

#include "rt_framebuffer.h"
namespace rt {
	// camera
	class camera_t {
		vec_t	eye, dir, up, right;
		float	fovx;			// stored as half fov
		int		world_up_index;
	public:
		bool_t open();
		void close() {}
		NOINLINE void look_at(const vec_t &target, const int up_idx = -1);
		void set_fovx(const float degree) { fovx = DEGRAD(degree)/2.f; }
		void set_eye(const vec_t &v) { eye = v; }
		FINLINE float get_fovx()			const { return RADDEG(fovx)*2.f; }
		FINLINE const vec_t &get_eye()		const { return eye; }
		FINLINE const vec_t &get_up()		const { return up; }	// stand up
		FINLINE const vec_t &get_dir()		const { return dir; }
		FINLINE const vec_t &get_right()	const { return right; }
		void set_world_up_index(int idx)	{ world_up_index = idx; }
		int get_world_up_index()			const { return world_up_index; }
		struct sampler_t {
			vec_t top, dx,dy;
			vec_t map(const point_t &screen) const { return vec_t(top + dx*float(screen.x) + dy*float(screen.y)); }
		} sampler;
		void update(const framebuffer_t &fb);
		void update(const point_t &pt);
	};
}
#endif
