/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


    Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/

#ifndef MATH_TRIANGLE_H
#define MATH_TRIANGLE_H

#include "math_vec.h"
#include "math_aabb.h"
#include "math_utility.h"

struct triangle_t {
    vec_t verts[3];
    triangle_t() {}
    triangle_t(const vec_t &a, const vec_t &b, const vec_t &c) {
        verts[0] = a;
        verts[1] = b;
        verts[2] = c;
    }
    FINLINE aabb_t get_aabb() const {
        return aabb_t(vec_t(minf(minf(verts[0].x,verts[1].x),verts[2].x),
                            minf(minf(verts[0].y,verts[1].y),verts[2].y),
                            minf(minf(verts[0].z,verts[1].z),verts[2].z)),
                      vec_t(maxf(maxf(verts[0].x,verts[1].x),verts[2].x),
                            maxf(maxf(verts[0].y,verts[1].y),verts[2].y),
                            maxf(maxf(verts[0].z,verts[1].z),verts[2].z)));
    }
};
#endif
