struct VSQuad_Input
{
    float4 Pos : POSITION;
    float2 Tex : TEXCOORD0;
};

struct VSQuad_Output
{
    float4 Pos : SV_POSITION;              
    float2 Tex : TEXCOORD0;
};

VSQuad_Output VSQuad(VSQuad_Input Input)
{
    VSQuad_Output Output;
    Output.Pos = Input.Pos;
    Output.Tex = Input.Tex;
    return Output;
}

StructuredBuffer<float4> buffer : register( t0 );

cbuffer cbPS : register( b0 )
{
    uint    width;   
};

float4 PSQuad(VSQuad_Output Input ) : SV_TARGET
{
    return buffer[(Input.Pos.y - 0.5) * width + Input.Pos.x - 0.5];	
}