/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef SYS_MAP_H
#define SYS_MAP_H


namespace sys {
	class map_t {
		void	*start, *stop;
		size_t	size;
		#if defined WINDOWS
			HANDLE	file, mapping;
		#else
			int		fd;
		#endif

		bool_t	mapped;

		void cleanup();
	public:
		bool_t is_mapped()	const { return mapped; }
		const char *begin()	const { return (const char*) start; }
		const char *end()	const { return (const char*) stop; }

		template <typename T> int get_size() const { return int(size / sizeof(T)); }

		bool_t open(const char *path);

		#if defined WINDOWS
			map_t() : start(0),stop(0), size(0), file(0),mapping(0), mapped(false) {}
		#else
			map_t() : start(0),stop(0), size(0),fd(0), mapped(false) {}
		#endif
		~map_t() { cleanup(); }
	};
}

#endif
