/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RESSOURCE_H
#define RESSOURCE_H

#include "specifics.h"

namespace rsc {
	// also works if done at declaration instead of definition time, and it's simpler...
	#ifdef __GCC__
		#define SECTION_RESSOURCE __attribute__((section ("RSC")))
	#else
		#define SECTION_RESSOURCE
	#endif

	// char id=32   x=0     y=0     width=1     height=0     xoffset=0     yoffset=20    xadvance=12    page=0 
	struct glyph_t {
		uint16_t	x, y;						// 32

		int8_t		offset_x, offset_y;			// 16
		uint8_t		width, height, xadvance;	// 24
		uint8_t		tag;						// 8 = 48
												// = 80
	};

	/*
	"	$h1{'face'},\n" .
	"	$h2{'scaleW'},$h2{'scaleH'},\n" .
	"	$h1{'size'},$h2{'lineHeight'},$h2{'base'},\n" .
	"	$h2{'pages'}\n" .
	*/
	struct headers_t {
		const char face[64];
		int16_t img_size_x, img_size_y;
		uint8_t size, line_height, base;
		uint8_t pages;
	};

	namespace console_font {
		extern const headers_t	headers		SECTION_RESSOURCE;
		extern const glyph_t	glyphs[]	SECTION_RESSOURCE;
		extern const unsigned char image[]	SECTION_RESSOURCE;
	}
}

NOINLINE void check_ressources();

#endif
