/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#include "math_constants.h"

#include "math_vec.h"
vec_t vec_t::zero = vec_t(0,0,0);

namespace cst {
	#if defined __MSVC__ // || defined __ICC_MSVC__
		#pragma const_seg(push, pristine, ".PIPOBIMBO")
		const section_t section = 
	#elif defined __GCC__
		const section_t section  __attribute__((section ("PIPOBIMBO"))) = 
	#elif defined __ICC_MSVC__
		// annoying as usual.
		#pragma warning(disable : 1026) // pff. pragma const_seg should be at global scope 
		#pragma const_seg(".PIPOBIMBO")
		const section_t section = 
	#else
		#error argh!
	#endif
	{
		{{ 0x7f800000,	0x7f800000,	0x7f800000,	0x7f800000 }},	// +inf
		{{ 0x40400000,	0x40400000,	0x40400000,	0x40400000 }},	// 3.f
		{{ 0x3f800000,	0x3f800000,	0x3f800000,	0x3f800000 }},	// 1.f
		{{ 0x3f000000,	0x3f000000,	0x3f000000,	0x3f000000 }},	// .5f

		{{ 0x00000000,	0x00000000,	0x00000000,	0x00000000 }},	// all clear
		{{ 0xFFFFFFFF,	0xFFFFFFFF,	0xFFFFFFFF,	0xFFFFFFFF }},	// all set
		{{ 0xff800000,	0xff800000,	0xff800000,	0xff800000 }},	// -inf
		{{ 0x437f0000,	0x437f0000,	0x437f0000,	0x437f0000 }},	// 255.f


		{{ 0x80000000,	0x80000000,	0x80000000,	0x80000000 }},	// sign bit, also -0.0f
		// on x86, the only [sq]NaN we'll ever see is 'indeterminate',
		// a value only defined in a draft of IEEE 754.
		// It's within valid NaN range anyway.
		// Hypothetically a qNaN would be like 0x7fc00000, sNan 0x7fc00001 (positive).
		{{ 0xffc00000,	0xffc00000,	0xffc00000,	0xffc00000 }},	// indeterminate, aka -1.#IND
		// 2 patterns for the sampler.
		{{ 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000 }},	// packet_pattern_mask_x
		{{ 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000 }},	// packet_pattern_mask_y


		// {{ 0xDEADBEEF, 0xDEADBEEF, 0xDEADBEEF, 0xDEADBEEF }},	// pad

		// single scalar selection
		{
			{{ 0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000 }},
			{{ 0x00000000, 0xFFFFFFFF, 0x00000000, 0x00000000 }},
			{{ 0x00000000, 0x00000000, 0xFFFFFFFF, 0x00000000 }},
			{{ 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF }}
		},

		// single scalar selection, the full thing.
		{
			{{ 0x00000000, 0x00000000, 0x00000000, 0x00000000 }},	// 0000
			{{ 0xFFFFFFFF, 0x00000000, 0x00000000, 0x00000000 }},	// 0001
			{{ 0x00000000, 0xFFFFFFFF, 0x00000000, 0x00000000 }},	// 0010
			{{ 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0x00000000 }},	// 0011

			{{ 0x00000000, 0x00000000, 0xFFFFFFFF, 0x00000000 }},	// 0100
			{{ 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x00000000 }},	// 0101
			{{ 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000 }},	// 0110
			{{ 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000 }},	// 0111

			{{ 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF }},	// 1000
			{{ 0xFFFFFFFF, 0x00000000, 0x00000000, 0xFFFFFFFF }},	// 1001
			{{ 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF }},	// 1010
			{{ 0xFFFFFFFF, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF }},	// 1011

			{{ 0x00000000, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF }},	// 1100
			{{ 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF }},	// 1101
			{{ 0x00000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF }},	// 1110
			{{ 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF }}	// 1111
		}
	};

	//const uint_t MM_ALIGN16 wald_modulo[] = { 0, 1, 2, 0, 1 };	// and rooted here.
	const uint_t MM_ALIGN16 wald_modulo[] 
		#ifdef __GCC__
			__attribute__((section ("PIPOBIMBO")))
		#endif
		= { 1, 2, 0, 1 };

	#ifdef __MSVC__
			#pragma const_seg(pop, pristine)
	#endif
}
