/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef KDLIB_SEGMENT_H_
#define KDLIB_SEGMENT_H_

#include "specifics.h"

namespace kdlib {
	template <typename T> union ptr_t {
		T * __restrict	p;
		ptrdiff_t		i;
	};

	/*
	struct list3d_t {
		segment_t	next[3], prev[3];
	};
	*/

	struct segment1D_t {
		float				val[2];
		ptr_t<segment1D_t>	next[2];
		ptr_t<segment1D_t>	prev[2];
	};

	struct segment_t {
		typedef ptr_t<segment1D_t> p_t;
		segment1D_t	segs[3]; // 3*((2*4)+(4*8)) = 3*(8 + 32)
		uint_t		tid;
		uint_t		pad;
	};
}
#endif
