/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef KDLIB_H_
#define KDLIB_H_

#include "specifics.h"

#include "math_vec.h"
#include "math_aabb.h"
#include "math_triangle.h"

// need to tweak warnings @ lvl 4.
#ifdef __MSVC__
	#pragma warning(disable : 4201 4127 )	// 4201: nameless union/struct, 4127: constant cond
#endif

#include <algorithm> // std:min/max

namespace kdlib {
	typedef ::triangle_t triangle_t;
	//typedef struct triangle_t triangle_t;
	//typename triangle_t;

	enum {
		#ifndef NDEBUG
			verbosity = 5, integrity = 5
			//verbosity = 0, integrity = 5
		#else
			//verbosity = 0, integrity = 0
			verbosity = 0, integrity = 1
		#endif
	};

	// tweakers
	struct tweak_sah_t {
		uint_t
			depth_max,		// maximum depth
			leaf_count_max,		// min/max triangles per leaf
			leaf_count_min,
			trigger_count;		// debug

		float
			cost_traversal,			// cost for a node traversal
			cost_intersection,		// cost for a primitive intersection
			microscopic_cell_ratio;	// ratio for cell area to be considered as too small vs parent.

		union {
			struct {
				uint_t	no_surrounding_splits : 1;
				uint_t	no_clipping : 1;
				uint_t	compress_ids : 1;
				uint_t	no_microscopic_cells : 1;
			};

			uint_t bits;
		} tweaks;


		// SAH tweaks
		//bool_t cell_border_method;	//FIX: tinkering.

		uint_t	complex_heuristic_threshold;



		// misc switches
		/*
		bool_t
			pre_sorting,		// pre sort all tri on 3 axes
			skip_same;		// certainly useless
		uint_t	sorting_key;		// min,max,center
		*/
	};


	// stats
	struct stats_build_t {
	};

	struct stats_tree_t {
		uint_t listed_items;
		uint_t empty_leaves;
		uint_t max_leaf_items;
		uint_t max_lvl;
	};


}

//extern int testzor(const std::vector<kdlib::triangle_t> &t);
//void *testzor(const triangle_t * __restrict const, const int num_tri);

#include "rt_kdtree.h"
bool_t kdlib_compile(const triangle_t * __restrict const, const int num_tri, kdtree::descriptor_t &, aabb_t &);

#endif
