/*
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *   Copyright (C) 2007  Benjamin Segovia <bsegovia@liris.cnrs.fr>
 */

#ifndef BVHLIB_H
#define BVHLIB_H

#include "math_triangle.h"
#include "rt_bvh.h"
#include "rt_sah.h"

namespace bvhlib {
    typedef ::triangle_t triangle_t;
}

#include "rt_bvh.h"
#include "math_constants.h"

struct bvh_hit_t {
	float    t;
	float    u,v;
	uint_t    id;
	FINLINE bvh_hit_t() : t(cst::section.plus_inf), u(0), v(0), id(~0u) {}
	FINLINE explicit bvh_hit_t(const float tmax) : t(tmax), u(0), v(0), id(uint_t(-1)) {}
	FINLINE bool is_hit() const { return id != ~0u; }
};

struct bvh_ray_t {
	explicit bvh_ray_t(const vec_t &o) : pos(o), dir(vec_t::zero), rcp_dir(vec_t::zero) {}
	const vec_t pos;
	const vec_t dir;
	const vec_t rcp_dir;

	void set_dir(const vec_t &d) const {
		(vec_t &)dir = d;
		(vec_t &)rcp_dir = vec_t(1.f/d.x, 1.f/d.y, 1.f/d.z);
	}
};

extern bool_t bvhlib_compile(const triangle_t * __restrict const, const uint32_t size_t, bvh::descriptor_t &);
extern void bvhlib_free(bvh::descriptor_t *bvhtree);
extern void trace_bvh(const bvh::descriptor_t &bvhtree, const bvh_ray_t &ray, bvh_hit_t &hit);

#endif

