#ifndef _Vector_H_
#define _Vector_H_

class Vector
{
public:
  Vector (const Vector &vec);
  Vector (float x=0.0, float y=0.0, float z=0.0);
  void Normalize ();
  float DotProduct (const Vector &vec);
  Vector CrossProduct (const Vector &vec);
  float GetLength ();
  float squaredLength ();

  Vector operator+ (const Vector &vec) const;
  Vector operator+ (const float &scalar) const;
  Vector operator- (const Vector &vec) const;
  Vector operator- (const float &scalar) const;
  Vector operator* (const float &scalar) const;
  Vector operator* (const Vector &vec) const;
  Vector operator/ (const float &scalar) const;
  Vector operator/ (const Vector &vec) const;
  Vector& operator+= (const Vector &vec);
  Vector& operator-= (const Vector &vec);
  Vector& operator*= (const float &scalar);
  Vector& operator/= (const float &scalar);
  Vector& operator = (const Vector &vec);
  bool operator == (const Vector &vec);
  bool operator != (const Vector &vec);

  float x, y, z;
};

#endif // _Vector_H_