#include "Vector.h"
#include <math.h>

Vector::Vector (const Vector &vec)
{
  x = vec.x;
  y = vec.y;
  z = vec.z;
}

Vector::Vector (float x, float y, float z)
{
  this->x = x;
  this->y = y;
  this->z = z;
}

void Vector::Normalize ()
{
  float len=GetLength();
  if(len!=0.0f) {
    float length = 1.0f/len;
    x *= length;
    y *= length;
    z *= length;
  }
}

float Vector::DotProduct (const Vector &vec)
{
  return (x * vec.x + y * vec.y + z*vec.z);
}

Vector Vector::CrossProduct (const Vector &vec)
{
  float a, b, c;
  a = y * vec.z - z * vec.y;
  b = - x * vec.z + x * vec.x;
  c = x * vec.y - y * vec.x;

  return Vector (a, b, c);
}

float Vector::GetLength()
{ 
  return sqrt(squaredLength());
}

float Vector::squaredLength ()
{
  return (x*x + y*y + z*z);
}

Vector Vector::operator+ (const Vector &vec) const
{
  return Vector (x+vec.x, y+vec.y, z+vec.z);
}

Vector Vector::operator+ (const float &scalar) const
{
  return Vector (x+scalar, y+scalar, z+scalar);
}

Vector Vector::operator- (const Vector &vec) const
{
  return Vector (x-vec.x, y-vec.y, z-vec.z);
}

Vector Vector::operator- (const float &scalar) const
{
  return Vector (x-scalar, y-scalar, z-scalar);
}

Vector Vector::operator* (const float &scalar) const
{
  return Vector (x*scalar, y*scalar, z*scalar);
}
Vector Vector::operator/ (const float &scalar) const
{
  return Vector (x/scalar, y/scalar, z/scalar);
}

Vector Vector::operator/ (const Vector &vec) const
{
  return Vector (x/vec.x, y/vec.y, z/vec.z);
//  return Vector (vec.x/x, vec.y/y, vec.z/z);
}

Vector Vector::operator* (const Vector &vec) const
{
  return Vector (x*vec.x, y*vec.y, z*vec.z);
}

Vector& Vector::operator+= (const Vector &vec)
{
  x += vec.x;
  y += vec.y;
  z += vec.z;
  return *this;
}
Vector& Vector::operator-= (const Vector &vec)
{
  x -= vec.x;
  y -= vec.y;
  z -= vec.z;
  return *this;
}
Vector& Vector::operator*= (const float &scalar)
{
  x *= scalar;
  y *= scalar;
  z *= scalar;
  return *this;
}
Vector& Vector::operator/= (const float &scalar)
{
  x /= scalar;
  y /= scalar;
  z /= scalar;
  return *this;
}

Vector& Vector::operator = (const Vector &vec)
{
  x = vec.x;
  y = vec.y;
  z = vec.z;
  return *this;
}

bool Vector::operator == (const Vector &vec)
{
	if (vec.x==x && vec.y==y && vec.z==z) return true;

	return false;
}

bool Vector::operator != (const Vector &vec)
{
	if (vec.x!=x || vec.y!=y || vec.z!=z) return true;

	return false;
}
