#include "Timer.h"

Timer::Timer ()
{
	QueryPerformanceFrequency(&frequency); // Initialisierung
	secondsPassed = 0;
}

void Timer::LoadStartTime()
{
	QueryPerformanceCounter(&time1);
}

void Timer::LoadNewTime()
{
	time1 = time2;
	QueryPerformanceCounter(&time2);
	secondsPassed = (double)(time2.QuadPart-time1.QuadPart)/(double)frequency.QuadPart;

	if( secondsPassed > 60*60 )
		secondsPassed = 0;
}

double Timer::getSecondsPassed()
{
	return secondsPassed;
}