#pragma once

#include "Matrix.h"
#include "Vector.h"

class Camera
{
public:
	Camera ();

	Vector lookAt;
	Vector position;
	Vector up;

	float distance;
	static const int DISTANCE_MIN = 1;
	static const int DISTANCE_MAX = 100;

	float angleX, angleY;
	OSkA::Matrix transform;

	void rotateX(float angle);
	void rotateY(float angle);
	void updateTransform();

	void increaseDistance();
	void decreaseDistance();

	void render();
};

