#version 120 

/*
 * Here are uniforms and attributes used by the animation shader.
 * So don't remove them.
 *
 * oskaWeights contains the top 4 bone weights of the actual vertex.
 * oskaInfluences contains the corresponding bone ids for the top 4
 * bone weights of oskaWeights.
 */
uniform mat4 oskaBones[40];

attribute vec4 oskaInfluences;
attribute vec4 oskaWeights;

void main()
{
	vec4 curVert = gl_Vertex;

	// TODO ARTR: generate a proper transformation matrix for vertex skinning, using the provided weights and influences
	mat4 transMat = mat4(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);

	vec3 normal = normalize(gl_NormalMatrix * mat3(transMat)* gl_Normal);
	vec3 lightDir = vec3(normalize(gl_LightSource[0].position));
	float NdotL = max(dot(normal, lightDir), 0.0);

	vec4 diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	vec4 ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	vec4 globalAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;

	gl_FrontColor = NdotL * vec4(0.9,0,0,1) + vec4(0.1,0,0,1);
	gl_Position = gl_ModelViewProjectionMatrix * transMat * curVert;
}
